/*  Entfernt alle Ressourcen-Optionen eines gegebenen Konexts für von einem gegebenen AG.
*/
SELECT tsystem.function__drop_by_regex( 'ab2__resource_requirement_options__remove_all', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__resource_requirement_options__remove_all(
      _ab2_id int,
      _context text --
  ) RETURNS boolean AS $$
  DECLARE

      _ab2_resource_id int := id FROM scheduling.resource WHERE context = 'ab2' and context_id = _ab2_id;

  BEGIN

      -- Sind die übgergbenen Parameter gültig?
      IF
            _ab2_id IS NULL
        OR _context IS NULL
      THEN
          RAISE EXCEPTION 'invalid parameter: _ab2_id: % _context: %', _ab2_id, _context;
      END IF;

      -- Lösche die Ressource-Optionen der Hauptressource
      DELETE FROM scheduling.resource_requirement_option rro
      USING scheduling.resource_requirement rr
      WHERE rro.requirement_id = rr.id
        AND rr.required_by = _ab2_resource_id
        AND rr.context = _context
      ;

      RETURN true;

  END $$ LANGUAGE plpgsql;